import React, {Component} from 'react';
import PropTypes from 'prop-types';
import ReactTable from "react-table";
import Loading from "../../../../core/Loading";
import './UsersList.css';
import Ionicon from 'react-ionicons'
import {NavLink} from "react-router-dom";
import moment from 'moment';
import 'moment/locale/it';

import Permissions from '../../../../permissions'

export default class UsersList extends Component {

  constructor(props) {
    super(props);

    this.state = {
      filter: '',
      paginationLimit: 50,
      paginationOffset: 1,
      columns: [
        {
          Header: "Codice fiscale",
          accessor: "id",
          filterable: false,
          sortable: false,
          width: 200,
        },
	{
          Header: "Cognome",
          accessor: "cognome",
          filterable: false,
          sortable: false,
        },
        {
          Header: "Nome",
          accessor: "nome",
          filterable: false,
          sortable: false,
        },
        
        {
          Header: "E-mail",
          accessor: "email",
          filterable: false,
          sortable: false,
        },
        {
          Header: "Scadenza",
          accessor: "scadenzaAccount",
          filterable: false,
          sortable: false,
        },
        {
          Header: "Ruolo",
          accessor: "ruolo.nomeEsteso",
          filterable: false,
          sortable: false,
	  width:200
        },
        {
          Header: "",
          sortable: false,
          filterable: false,
          accessor: "id",
          Cell: (row) => (<div style={{display: 'flex', alignItems: 'center'}}>
            <div className="btn-group btn-group-sm" style={{margin: '0 auto'}}>
              <NavLink className="btn ionicon-btn btn-light" to={props.match.url + "/" + row.value}>
                <Ionicon icon="ios-search-outline" />
              </NavLink>
              <NavLink className="btn ionicon-btn btn-light" to={props.match.url + "/" + row.value + "/edit"}>
                  <Ionicon icon="ios-create-outline"/>
              </NavLink>
            </div>
          </div>),
        },
      ]
    };

    this.onFetchData = this.onFetchData.bind(this);
    this.onFilterChange = this.onFilterChange.bind(this);
    this.getTotalPages = this.getTotalPages.bind(this);
  }

  componentWillMount() {
    moment.locale("it")
  }

  onFetchData(state, instance) {
    this.props.data.refetch({
      pagination: {
        limit: state.pageSize,
        offset: state.page * state.pageSize,
      },
      filtro: this.state.filters,
      //sort: sortObj,
    })
    this.setState({
      paginationLimit: state.pageSize,
      paginationOffset: state.page * state.pageSize
    })
  }

  onFilterChange(filter) {
    this.setState({filter: filter})

    this.props.data.refetch({
      pagination: {
        limit: this.state.paginationLimit,
        offset: this.state.paginationOffset
      },
      filtro: filter,
      //sort: sortObj,
    })
  }

  getTotalPages () {
    if (this.props.data.countUtentes2 > 0) {
      return Math.ceil(this.props.data.countUtentes2 / this.state.paginationLimit)
    }

    return 0
  }

  render() {
    const {
      data,
      match,
      utenteSessione
    } = this.props

   

    const {
      columns,
      pages,
    } = this.state

    if(data.error) {
      return(<div className="text-danger">
        Errore nella ricezione dei dati
      </div>)
    }

    if(data.loading) {
        return <Loading/>;
    }

        if( utenteSessione.utenteSessione.ruolo.permessi.filter(item => item.id == Permissions.adminUsers).length==0) {
      return(<div className="text-danger">
        Privilegi insufficienti per visualizzare questa schermata
      </div>)
    }

    

    return(
      
      <div className="container-fluid">
        <div className="btn-toolbar" style={{backgroundColor: '#fff'}}>
          <div className="btn-group mr-2 ml-auto">
            <NavLink className="btn ionicon-btn btn-light" to={match.url + "/create"}>
                <Ionicon icon="ios-add" style={{marginRight: '5px', marginLeft: '-8px'}}/>
                Nuovo Utente
            </NavLink>
            <button className="btn ionicon-btn btn-light" onClick={() => window.open('/LifeEremitaWeb/csv/utenti/*/utenti.csv')} type="button">
              <Ionicon icon="ios-exit-outline" style={{marginRight: '5px', marginLeft: '-8px'}} />
              Esporta CSV
            </button>
          </div>
        </div>


        <ReactTable
          manual
          filterable
          loading={data.loading}
          noDataText={"Nessun Utente Presente"}
          onFetchData={this.onFetchData}
          pages={this.getTotalPages()}
          className="-highlight"
          data={data.utentes2}
          style={{maxHeight: "500px"}}
          defaultPageSize={50}
          nextText="Avanti"
          previousText="Indietro"
          loadingText="Caricamento in corso..."
          rowsText="elementi"
          ofText="di"
          pageText="Pagina"
          columns={columns} />
      </div>
    )
  }
}



UsersList.defaultProps = {}

UsersList.propTypes = {

}
